/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitDataSet;
import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.Config;
import util.Logger;

public class DDF0XAWriter {
    static Logger logger = Logger.getLogger();
    private FitDataSet mydata;
    private File myOutfile;
    private PrintStream pst;

    public DDF0XAWriter(File of, FitDataSet ps) {
        logger.entry(4, "DDF0XAWriter.DDF0XAWriter");
        this.myOutfile = of;
        this.mydata = ps;
        try {
            this.pst = new PrintStream(this.myOutfile);
        }
        catch (Exception e) {
            logger.log(1, "ERROR : " + e.toString());
        }
        logger.exit(4, "DDF0XAWriter.DDF0XAWriter");
    }

    public void write() {
        Config cfg = Config.getConfig();
        SimpleDateFormat sdf = new SimpleDateFormat("d.M.yy");
        String date = sdf.format(new Date());
        for (double f : this.mydata.getFrequencies()) {
            this.pst.print("TYPE:66\r\n");
            this.pst.print("0\r\n");
            this.pst.print(String.valueOf(date) + "\r\n");
            String antCode = cfg.getParam("Antennacode");
            this.pst.print(antCode);
            int i = antCode.length();
            while (i < 6) {
                this.pst.print(" ");
                ++i;
            }
            this.pst.print("# " + cfg.getParam("Antennaname") + "\r\n");
            int nodes = this.mydata.getFitData(f).getNodesIn();
            this.pst.print(String.valueOf(nodes * 10) + "\r\n");
            i = 0;
            while (i < this.mydata.getFitData(f).getNodesIn()) {
                double val1 = this.mydata.getFitData(f).getXin(i);
                double val2 = i < this.mydata.getFitData(f).getNodesIn() - 1 ? this.mydata.getFitData(f).getXin(i + 1) : this.mydata.getFitData(f).getXin(0);
                val1 = this.mydata.getFitData(f).getCorrectedVal(val1);
                val2 = this.mydata.getFitData(f).getCorrectedVal(val2);
                int icorr100 = (int)Math.rint(val1 * 100.0);
                this.pst.print(String.valueOf(icorr100) + "\r\n");
                if (val2 - val1 < 0.0) {
                    val1 -= 360.0;
                }
                double delta = (val2 - val1) / 10.0;
                int n = 1;
                while (n < 10) {
                    double vali = val1 + delta * (double)n;
                    icorr100 = (int)Math.rint(vali * 100.0);
                    if (icorr100 < 0) {
                        icorr100 += 36000;
                    }
                    this.pst.print(String.valueOf(icorr100) + "\r\n");
                    ++n;
                }
                ++i;
            }
            this.pst.print("END\r\n");
        }
    }
}

